<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\Dashboard\FaqController;
use App\Http\Controllers\API\Dashboard\AuthController;
use App\Http\Controllers\API\Dashboard\NoteController;
use App\Http\Controllers\API\Dashboard\PageController;
use App\Http\Controllers\API\Dashboard\RoleController;
use App\Http\Controllers\API\Dashboard\AdminController;
use App\Http\Controllers\API\Dashboard\OrderController;
use App\Http\Controllers\API\Dashboard\StatusController;
use App\Http\Controllers\API\Dashboard\ClientsController;
use App\Http\Controllers\API\Dashboard\ContactController;
use App\Http\Controllers\API\Dashboard\CountryController;
use App\Http\Controllers\API\Dashboard\PartnerController;
use App\Http\Controllers\API\Dashboard\PaymentController;
use App\Http\Controllers\API\Dashboard\ProductController;
use App\Http\Controllers\API\Dashboard\ServiceController;
use App\Http\Controllers\API\Dashboard\SettingController;
use App\Http\Controllers\API\Dashboard\CategoryController;
use App\Http\Controllers\API\Dashboard\DiscountController;
use App\Http\Controllers\API\Dashboard\OverViewController;
use App\Http\Controllers\API\Dashboard\ReferralController;
use App\Http\Controllers\API\Dashboard\PermissionController;
use App\Http\Controllers\API\Dashboard\SliderCardController;
use App\Http\Controllers\API\Dashboard\StaticPageController;
use App\Http\Controllers\API\Dashboard\NotificationController;
use App\Http\Controllers\API\Dashboard\AdvertisementController;

Route::post('/login', [AuthController::class, 'login']);
Route::post('/email-verify', [AuthController::class, 'emailVerify']);
// Route::post('/verify-otp', [AuthController::class, 'verifyOtp']);
// Route::post('/reset-password', [AuthController::class, 'resetPassword']);
Route::post('password/send-otp', [AuthController::class, 'sendResetOtp']);
Route::post('password/verify-otp', [AuthController::class, 'verifyResetOtp']);
Route::post('password/reset', [AuthController::class, 'resetPassword']);


Route::post('/change-password', [AuthController::class, 'changePassword'])->middleware('auth:sanctum');
Route::middleware('auth:admin')->group(function () {
    //   Route::get('/get-data', [AuthController::class, 'getUser']);
    Route::get('/profile', [AdminController::class, 'getUser']);
    Route::post('/profile/image', [AdminController::class, 'UpdateImageProfile']);
    Route::delete('/profile/image', [AdminController::class, 'DeleteImageProfile']);

    Route::put('/profile', [AdminController::class, 'updateUser']);
    Route::post('/logout', [AuthController::class, 'logout']);

    Route::prefix('clients')->group(function () {
        Route::get('/', [ClientsController::class, 'index']);
        Route::get('/notices/{id}', [ClientsController::class, 'notices']);
        Route::get('/{id}/referral-stats', [ReferralController::class, 'referralStats']);
        Route::get('/{id}', [ClientsController::class, 'show']);
        Route::post('/{id}', [ClientsController::class, 'update']);
        Route::patch('/{id}/status', [ClientsController::class, 'updateStatus']);
        Route::delete('/{id}', [ClientsController::class, 'destroy']);
        Route::get('/export', [ClientsController::class, 'export'])->name('clients.export');
        Route::get('/payments/{id}', [ClientsController::class, 'payments']);
    });
    Route::prefix('orders')->group(function () {
        Route::get('/', [OrderController::class, 'index']);
        Route::post('/{id}/status', [OrderController::class, 'changeStatus']);
        Route::get('/new', [OrderController::class, 'newOrders']);
        Route::get('/canceled', [OrderController::class, 'canceledOrders']);
        Route::get('/status', [OrderController::class, 'getStatus']);
    });

    Route::prefix('products')->group(function () {
        Route::get('/', [ProductController::class, 'index']);
        Route::get('/{id}', [ProductController::class, 'show']);
        Route::post('/', [ProductController::class, 'store']);
        Route::post('/{id}', [ProductController::class, 'update']);
        Route::delete('/{id}', [ProductController::class, 'destroy']);
    });

    Route::prefix('services')->group(function () {
        Route::get('/', [ServiceController::class, 'index']);
        Route::get('/{id}', [ServiceController::class, 'show']);
        Route::post('/', [ServiceController::class, 'store']);
        Route::post('/{id}', [ServiceController::class, 'update']);
        Route::delete('/{id}', [ServiceController::class, 'destroy']);
    });

    Route::get('/get-data-product', [ProductController::class, 'getCreateEditData']);

    Route::prefix('statuses')->group(function () {
        Route::get('/', [StatusController::class, 'index']);
        Route::post('/{id}', [StatusController::class, 'update']);
    });

    Route::prefix('setting')->group(function () {
        Route::get('/social-media', [SettingController::class, 'getSocialMedia']);
        Route::post('/social-media', [SettingController::class, 'updateSocialMedia']);
        Route::post('/update', [SettingController::class, 'update']);
    });


    Route::prefix('categories')->group(function () {
        Route::get('/', [CategoryController::class, 'index']);
        Route::post('/', [CategoryController::class, 'store']);
        Route::delete('/{id}', [CategoryController::class, 'destroy']);
        Route::post('/{id}', [CategoryController::class, 'update']);
    });


    Route::prefix('static-pages')->group(function () {
        Route::get('/', [StaticPageController::class, 'index']);
        Route::post('/', [StaticPageController::class, 'update']);
    });

    Route::prefix('notifications')->group(function () {
        Route::post('/send', [NotificationController::class, 'send']);
        route::get('/users/{userId}', [NotificationController::class, 'client']);
        route::delete('/users/{userId}', [NotificationController::class, 'destroy']);

        Route::get('/last-messages', [NotificationController::class, 'getLastMessage']);
    });

    Route::prefix('faqs')->group(function () {
        Route::get('/', [FaqController::class, 'index']);
        Route::post('/', [FaqController::class, 'store']);
        Route::get('/{id}', [FaqController::class, 'show']);
        Route::put('/{id}', [FaqController::class, 'update']);
        Route::delete('/{id}', [FaqController::class, 'destroy']);
    });
    // Route::prefix('faqs')->group(function () {
    //     Route::get('/', [FaqController::class, 'index']);
    //     Route::post('/', [FaqController::class, 'store']);
    //     Route::get('/{id}', [FaqController::class, 'show']);
    //     Route::put('/{id}', [FaqController::class, 'update']);
    //     Route::delete('/{id}', [FaqController::class, 'destroy']);
    // });
    Route::prefix('contacts')->group(function () {
        Route::get('/', [ContactController::class, 'index']);
        Route::delete('/{id}', [ContactController::class, 'destroy']);

        Route::put('/{id}/respond', [ContactController::class, 'respond']);
    });

    Route::prefix('pages')->group(function () {
        Route::get('/', [PageController::class, 'index']);
        Route::post('/', [PageController::class, 'store']);
        Route::get('/{id}', [PageController::class, 'show']);
        Route::put('/{id}', [PageController::class, 'update']);
        Route::delete('/{id}', [PageController::class, 'destroy']);
    });

    Route::prefix('overview')->group(function () {
        Route::get('/site-activity', [OverViewController::class, 'SiteActivity']);
        Route::get('/webget-web', [OverViewController::class, 'Webget']);
        Route::get('/statistics', [OverViewController::class, 'statistics']);
        Route::get('/advanced-statistics', [OverViewController::class, 'advancedStatistics']);
        Route::get('/marketing-statistics', [OverViewController::class, 'marketingStatistics']);
    });

    // silder Routes
    Route::prefix('silder')->group(function () {
        Route::get('/', [SliderCardController::class, 'getSliders']);
        Route::post('/', [SliderCardController::class, 'createSlider']);
        Route::delete('/{id}', [SliderCardController::class, 'deleteSlider']);
    });
    // banner Routes
    Route::prefix('banner')->group(function () {
        Route::get('/', [SliderCardController::class, 'getBanners']);
        Route::post('/', [SliderCardController::class, 'createBanner']);
        Route::delete('/{id}', [SliderCardController::class, 'deleteBanner']);
    });

    // partners Routes
    Route::prefix('partners')->group(function () {
        Route::get('/', [PartnerController::class, 'getPartners']);
        Route::get('/{id}', [PartnerController::class, 'getPartner']);
        Route::post('/', [PartnerController::class, 'createPartner']);
        Route::post('/{id}', [PartnerController::class, 'updatePartner']);
        Route::delete('/{id}', [PartnerController::class, 'deletePartner']);
    });
    // discounts Routes
    Route::prefix('discounts')->group(function () {
        Route::get('/', [DiscountController::class, 'getDiscounts']);
        Route::post('/', [DiscountController::class, 'createDiscount']);
        Route::delete('/{id}', [DiscountController::class, 'deleteDiscount']);
    });

    // advertisements Routes
    Route::prefix('advertisements')->group(function () {
        Route::get('/', [AdvertisementController::class, 'index']);
        // Route::post('/', [AdvertisementController::class, 'store']);
        Route::post('/{id?}', [AdvertisementController::class, 'upsert']);
        Route::delete('/{id}', [AdvertisementController::class, 'destroy']);
    });

    // note Routes
    Route::prefix('note')->group(function () {
        Route::post('/', [NoteController::class, 'createNotes']);
        Route::get('/users', [NoteController::class, 'getAllUsers']);
        Route::get('/{userId}', [NoteController::class, 'getUserNotes']);
        Route::put('/{userId}/{noteId}', [NoteController::class, 'updateNote']);
    });

    // Role Routes
    Route::prefix('roles')->group(function () {
        Route::get('', [RoleController::class, 'index']);
        Route::post('', [RoleController::class, 'store']);
        Route::get('/{role}', [RoleController::class, 'show']);
        Route::put('/{role}', [RoleController::class, 'update']);
        Route::delete('/{role}', [RoleController::class, 'destroy']);
        Route::post('/{role}/permissions', [RoleController::class, 'assignPermission']);
        Route::delete('/{role}/permissions/{permission}', [RoleController::class, 'removePermission']);
    });

    // Permission Routes
    Route::prefix('permissions')->group(function () {
        Route::get('', [PermissionController::class, 'index']);
        Route::post('', [PermissionController::class, 'store']);
        Route::get('/{permission}', [PermissionController::class, 'show']);
        Route::put('/{permission}', [PermissionController::class, 'update']);
        Route::delete('/{permission}', [PermissionController::class, 'destroy']);
    });

    // Admin Routes
    Route::prefix('admins')->group(function () {
        Route::get('', [AdminController::class, 'index']);
        Route::post('', [AdminController::class, 'store']);
        Route::get('/{admin}', [AdminController::class, 'show']);
        Route::post('/{admin}/image', [AdminController::class, 'updateImage']);
        Route::delete('/{admin}', [AdminController::class, 'destroy']);
        Route::post('/{admin}/roles', [AdminController::class, 'assignRole']);
        Route::put('/{admin}', [AdminController::class, 'update']);
        Route::delete('/{admin}/image', [AdminController::class, 'deleteImage']);
    });

    Route::apiResource('countries', CountryController::class);
    Route::get('/payments', [PaymentController::class, 'index']);
    Route::get('/payments/{id}', [PaymentController::class, 'show']);
});
