<?php

namespace Database\Seeders;

use App\Models\WebsiteVisit;
use Illuminate\Database\Seeder;
use Faker\Factory as Faker;

class WebsiteVisitSeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create();

        // Array of realistic countries
        $countries = [
            'United States',
            'United Kingdom',
            'Canada',
            'Australia',
            'Germany',
            'France',
            'Saudi Arabia',
            'United Arab Emirates',
            'Egypt',
            'Jordan',
            'India',
            'China',
            'Japan',
            'Brazil',
            'South Africa'
        ];

        // Array of realistic referrer URLs
        $referrerUrls = [
            'https://www.google.com',
            'https://www.facebook.com',
            'https://www.twitter.com',
            'https://www.linkedin.com',
            'https://www.instagram.com',
            null, // Some visits have no referrer
        ];

        // Generate 100 fake website visits
        for ($i = 0; $i < 100; $i++) {
            WebsiteVisit::create([
                'visitor_ip' => $faker->ipv4, // Random IPv4 address
                'country' => $faker->randomElement($countries), // Random country from list
                'visit_timestamp' => $faker->dateTimeBetween('-1 month', 'now'), // Random timestamp in last month
                'visit_count' => $faker->numberBetween(1, 10), // Random visit count between 1 and 10
                'referrer_url' => $faker->randomElement($referrerUrls), // Random referrer URL or null
            ]);
        }
    }
}