<?php

namespace Database\Seeders;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Point;
use Faker\Factory as Faker;
use Illuminate\Database\Seeder;

class PointSeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create();

        // Define possible model names
        $modelNames = ['User', 'Order', 'Product'];

        // Generate 400 points
        for ($i = 0; $i < 400; $i++) {
            Point::create([
                'point_x' => $faker->randomFloat(2, 1, 100),
                'point_y' => $faker->randomFloat(2, 1, 100),
                'model_name' => User::class,
                'model_id' => $faker->numberBetween(1, 150),
                'created_at' => Carbon::now()->subDays($faker->numberBetween(1, 365)),

            ]);
        }
    }
}