<?php

namespace Database\Seeders;

use App\Models\Order;
use App\Models\OrderItem;
use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Faker\Factory as Faker;

class OrderSeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create('ar_SA');

        $paymentMethods = ['Credit Card', 'PayPal', 'Cash on Delivery'];
        $statuses = [1, 2, 3, 4];
        $products = array_merge(range(2, 6), range(12, 16));
        $users = range(52, 150);

        for ($i = 0; $i < 300; $i++) {
            $userId = $faker->randomElement($users);
            $totalPrice = 0;
            $orderItemsCount = $faker->numberBetween(1, 5);

            $order = Order::create([
                'user_id' => $userId,
                'phone_number' => $faker->phoneNumber,
                'total_price' => 0,
                'shipping_address' => $faker->address,
                'payment_method' => $faker->randomElement($paymentMethods),
                'tracking_number' => 'TRK' . str_pad($i + 1000, 6, '0', STR_PAD_LEFT),
                'status_id' => $faker->numberBetween(1, 4),

                'full_name' => $faker->name,
                'email' => $faker->email,
                'created_at' => Carbon::now()->subDays($faker->numberBetween(1, 365)),
                'updated_at' => Carbon::now(),
            ]);

            for ($j = 0; $j < $orderItemsCount; $j++) {
                $productPrice = $faker->randomFloat(2, 10, 500);
                $itemPrice = $productPrice * $faker->numberBetween(1, 3);
                $totalPrice += $itemPrice;

                OrderItem::create([
                    'order_id' => $order->id,
                    'product_id' => $faker->randomElement($products),
                    'discount_id' => $faker->optional(0.3)->numberBetween(2, 7), // 30% chance of having a discount
                    'price' => $itemPrice,
                    'created_at' => $order->created_at,
                    'updated_at' => $order->updated_at,
                ]);
            }

            // Update total price of the order
            $order->update(['total_price' => $totalPrice]);
        }
    }
}