<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSettingsTable extends Migration
{
    // إنشاء جدول الإعدادات
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->time('work_start_time')->nullable();
            $table->time('work_end_time')->nullable();
            $table->string('work_days')->nullable();
            $table->string('facebook')->nullable();
            $table->string('instagram')->nullable();
            $table->string('x')->nullable();
            $table->string('linkedin')->nullable();
            $table->string('discord')->nullable();
            $table->text('copyright')->nullable();
            $table->string('logo')->nullable();
            $table->text('address')->nullable();
            $table->string('phone_number', 20)->nullable();
            $table->string('youtube')->nullable();
            $table->string('pinterest')->nullable();
            $table->text('welcome_message')->nullable();
            $table->string('color_top_header', 7)->nullable();
            $table->string('color_navbar', 7)->nullable();
            $table->string('color_footer', 7)->nullable();
            $table->string('whatsapp', 20)->nullable();
            $table->boolean('maintenance_mode')->default(0);

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('settings');
    }
}