<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class CustomVerifyEmail extends Notification
{
    use Queueable;

    protected $otp;

    public function __construct($otp)
    {
        $this->otp = $otp;
    }

    public function via($notifiable)
    {
        return ['mail'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('كود تفعيل البريد الإلكتروني')
            ->line('استخدم كود التفعيل التالي لتأكيد بريدك الإلكتروني:')
            ->line("كود التفعيل: **{$this->otp}**")
            ->line('إذا لم تقم بإنشاء حساب، يمكنك تجاهل هذا البريد.');
    }
}