<?php

/*
    Created by Mohamed.
*/


namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PointsTransaction extends Model
{
    use HasFactory;

    protected $fillable = ['user_id', 'points', 'action_type', 'related_id'];

    protected $casts = [
        'points' => 'integer',
        'action_type' => 'string',
        'created_at' => 'datetime',
    ];

    // Relationships
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}