<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    protected $table = 'packages';

    protected $fillable = [
        'service_id',
        'name',
        'price',
    ];

    protected $casts = [
        'service_id' => 'int',
        'price' => 'float',
    ];

    public function service()
    {
        return $this->belongsTo(Service::class);
    }
}
