<?php

/*
    Created by Mohamed.
*/

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Country extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<string>
     */
    protected $fillable = ['name'];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'name' => 'array',
    ];
    /**
     * Get the governorates for the country.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function governorates(): HasMany
    {
        return $this->hasMany(Governorate::class);
    }

    /**
     * Get the country name in the specified locale.
     *
     * @param string $locale
     * @return string|null
     */
    public function getName(string $locale = 'en'): ?string
    {
        return $this->name[$locale] ?? null;
    }
}