<?php

/*
	Created by Mohamed.
*/

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class CartItem
 * 
 * @property int $id
 * @property int|null $product_id
 * @property int $quantity
 * @property int $cart_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Cart $cart
 * @property Product|null $product
 *
 * @package App\Models
 */
class CartItem extends Model
{
	protected $table = 'cart_items';

	protected $casts = [
		'product_id' => 'int',
		'quantity' => 'int',
		'cart_id' => 'int'
	];

	protected $fillable = [
		'product_id',
		'quantity',
		'cart_id'
	];

	public function cart()
	{
		return $this->belongsTo(Cart::class);
	}

	public function product()
	{
		return $this->belongsTo(Product::class);
	}
}
