<?php

/*
    Created by Mohamed.
*/

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Advertisement extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'image',
        'location_type',
        'locatable_type',
        'locatable_id',
        'key',
        'product_id',
        'color',
        'price',
        'discount',
        'link',
        'btn_bg_color',
        'border_btn_color',
        'text_btn',
        'default_image',
        'status',
        'order',
        'bg_ads_color_default'
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'discount' => 'decimal:2',
        'order' => 'integer',
        'key' => 'integer',
    ];

    /**
     * Get the parent locatable model (morph relation).
     */
    public function locatable()
    {
        return $this->morphTo();
    }

    /**
     * علاقة إعلان مع منتج واحد.
     */
    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }
}
