<?php

/*
    Created by Mohamed.
*/


namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class AdminRole extends Model
{
    protected $table = 'admin_role'; // اسم الجدول

    protected $fillable = [
        'admin_id',
        'role_id',
    ];

    // العلاقة مع Admin
    public function admin()
    {
        return $this->belongsTo(Admin::class);
    }

    // العلاقة مع Role
    public function role()
    {
        return $this->belongsTo(Role::class);
    }

    // إذا كنت لا تستخدم timestamps أو تريد تعطيلها:
    public $timestamps = true;
}