<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use App\Notifications\ResetPassword as ResetPasswordNotification;
use App\Notifications\CustomVerifyEmail;

/**
 * Class Admin
 * 
 * @property int $id
 * @property string $type
 * @property string $name
 * @property string|null $phone_number
 * @property string|null $email
 * @property string $password
 * @property string|null $image
 * @property string $gender
 * @property int|null $admin_id
 * @property Carbon|null $email_verified_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $role
 * @property Carbon|null $start_date
 * @property Carbon|null $end_date
 * @property string|null $total_working_hours
 * @property string|null $performance
 * @property string|null $level
 * @property string|null $commitment
 * @property string|null $behavior
 * @property int|null $rating
 * @property int|null $projects
 * @property int|null $development
 * @property string|null $promotion
 * @property string|null $work_hours
 * @property string|null $extra_time
 * @property int|null $absence
 * @property int|null $delay
 * @property int|null $permission
 * @property int|null $deduct
 *
 * @package App\Models
 */
class Admin extends Authenticatable implements MustVerifyEmail
{
	use HasApiTokens, Notifiable;

	protected $table = 'admins';

	protected $hidden = [
		'password'
	];

	protected $casts = [
		'email_verified_at' => 'datetime',
		'start_date' => 'datetime',
		'end_date' => 'datetime',
		'total_working_hours' => 'string',
		'rating' => 'integer',
		'projects' => 'integer',
		'development' => 'integer',
		'absence' => 'integer',
		'delay' => 'integer',
		'permission' => 'integer',
		'deduct' => 'integer',
	];

	protected $fillable = [
		'type',
		'name',
		'phone_number',
		'email',
		'password',
		'image',
		'gender',
		'code',
		'otp',
		'city',
		'street',
		'addres_line',
		'qualification',
		'current_adjective',
		'country_id',
		'start_date',        // e.g., "25/3/2024"
		'end_date',          // e.g., "25/3/2023" or null
		'total_working_hours', // e.g., "78:30:00"
		'performance',       // e.g., "average"
		'level',             // e.g., "Admin"
		'commitment',        // e.g., "very good"
		'behavior',          // e.g., "very good"
		'rating',            // e.g., 5
		'projects',          // e.g., 0
		'development',       // e.g., 0
		'promotion',         // e.g., "no"
		'work_hours',        // e.g., "6 H per day"
		'extra_time',        // e.g., "5 H in month"
		'absence',           // e.g., 1
		'delay',             // e.g., 3
		'permission',        // e.g., 1
		'deduct',            // e.g., 2
	];

	public function roles()
	{
		return $this->belongsToMany(Role::class, 'admin_role');
	}
	public function adminNotes()
	{
		return $this->hasMany(Note::class, 'admin_id');
	}
	public function country()
	{
		return $this->belongsTo(Country::class);
	}
}