<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class GoogleRegistrationMail extends Mailable
{
    use Queueable, SerializesModels;

    public $password;
    public $locale;

    /**
     * Create a new message instance.
     *
     * @param string $password
     * @param string $locale
     * @return void
     */
    public function __construct($password, $locale)
    {
        $this->password = $password;
        $this->locale = $locale;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject(trans('messages.google_registration_subject', [], $this->locale))
            ->view('emails.google_registration')
            ->with([
                'password' => $this->password,
                'locale' => $this->locale,
            ]);
    }
}
