<?php

/*
 * Created by Mohamed.
*/

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SettingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'                => $this->id,
            'work_start_time'   => $this->work_start_time,
            'work_end_time'     => $this->work_end_time,
            'work_days'         => $this->work_days,
            'facebook'          => $this->facebook,
            'instagram'         => $this->instagram,
            'x'                 => $this->x,
            'linkedin'          => $this->linkedin,
            'discord'           => $this->discord,
            'youtube'           => $this->youtube,
            'pinterest'         => $this->pinterest,
            'email'             => $this->email,
            'phone_number'      => $this->phone_number,
            'address'           => $this->address,
            'whatsapp'          => $this->whatsapp,
            'welcome_message'   => $this->welcome_message,
            'copyright'         => $this->copyright,
            'color_top_header'  => $this->color_top_header,
            'color_navbar'      => $this->color_navbar,
            'color_footer'      => $this->color_footer,
            'maintenance_mode'  => (bool) $this->maintenance_mode,

            'logo'              => $this->logo ? asset('storage/' . $this->logo) : null,
            'header_logo_ar'    => $this->header_logo_ar ? asset('storage/' . $this->header_logo_ar) : null,
            'header_logo_en'    => $this->header_logo_en ? asset('storage/' . $this->header_logo_en) : null,

            // 'created_at'        => $this->created_at?->format('Y-m-d H:i:s'),
            // 'updated_at'        => $this->updated_at?->format('Y-m-d H:i:s'),
        ];
    }
}
