<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class QuickOfferResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id'             => $this->id,
            'offer_title'    => $this->offer_title,
            'discount_type'  => $this->discount_type,
            'discount_value' => $this->discount_value,
            'start_date'     => $this->start_date,
            'end_date'       => $this->end_date,
            'product'        => new ProductResource($this->product),
        ];
    }
}
