<?php

namespace App\Http\Resources;

use App\Http\Controllers\API\CountryController;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends BaseResource
{
    public function toArray($request)
    {
        // Get currency details based on IP
        $countryController = new CountryController();
        $currencyData = $countryController->getCountryAndCurrency($request);

        // Default to USD
        $currencyCode = 'USD';
        $currencySymbol = '$';
        $currencyName = 'United States Dollar';
        $exchangeRate = 1;
        $country = 'Unknown';

        if ($currencyData->getStatusCode() === 200) {
            $currencyInfo = json_decode($currencyData->getContent(), true);
            $currencyCode = $currencyInfo['currency']['code'] ?? 'USD';
            $currencySymbol = $currencyInfo['currency']['symbol'] ?? '$';
            $currencyName = $currencyInfo['currency']['name'] ?? 'United States Dollar';
            $exchangeRate = $currencyInfo['currency']['exchange_rate'] ?? 1;
            $country = $currencyInfo['country'] ?? 'Unknown';
        }

        $convertedPrice = $this->price * $exchangeRate;
        $convertedOfferValue = $this->offer ? $this->offer->value * $exchangeRate : null;

        return [
            'id' => $this->id,
            'category_id' => $this->category_id,
            'sku' => $this->sku,
            'status_id' => $this->status_id,
            'name' => $this->translate('name') ?? $this->name,
            'description' => $this->translate('description') ?? $this->description,
            'short_description' => $this->translate('short_description') ?? $this->short_description,
            'image' => $this->image ? asset('storage/' . $this->image) : null,
            'price' => round($convertedPrice, 2), // Keep price as a single value
            'stock' => $this->stock,
            'publish_at' => $this->publish_at,
            'visibility' => $this->visibility,
            'manufacturer_name' => $this->manufacturer_name,
            'manufacturer_brand' => $this->manufacturer_brand,
            'label' => $this->label,
            'type' => $this->type,
            'offer' => $this->offer ? [
                'value' => round($convertedOfferValue, 2), // Convert offer value
                // 'type' => $this->offer->type
            ] : null,
            'created_at' => $this->created_at,
            'category' => new CategoryResource($this->category),
            'advertisements' => AdvertisementResource::collection($this->advertisements),
            'status' => new StatusResource($this->whenLoaded('status')),
            'cart_items' => CartItemResource::collection($this->whenLoaded('cart_items')),
            'discounts' => DiscountResource::collection($this->discounts),
            'reviews' => ReviewResource::collection($this->reviews),
            'reviews_rate' => $this->reviews->whereNotNull('rating')->count(),
            'images' => ImageResource::collection($this->images),
            'tags' => TagResource::collection($this->whenLoaded('tags')),
            // New fields for currency context
            'currency_code' => $currencyCode,
            'currency_symbol' => $currencySymbol,
            'currency_name' => $currencyName,
            'country' => $country,
            'services' => ServiceResource::collection($this->services),

        ];
    }
}
