<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PackageResource extends JsonResource
{
    public function toArray($request)
    {
        $countryController = new \App\Http\Controllers\API\CountryController();
        $currencyData = $countryController->getCountryAndCurrency($request);
        $exchangeRate = 1;

        if ($currencyData->getStatusCode() === 200) {
            $currencyInfo = json_decode($currencyData->getContent(), true);
            $exchangeRate = $currencyInfo['currency']['exchange_rate'] ?? 1;
        }

        return [
            'id' => $this->id,
            'name' => $this->name,
            'price' => round($this->price * $exchangeRate, 2),
        ];
    }
}
