<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderItemResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'order_id' => $this->order_id,
            'product_id' => $this->product_id,
            'discount_id' => $this->discount_id,
            'price' => $this->price,
            'product' => new ProductResource($this->product),
            'discount' => $this->discount ? [
                'id' => $this->discount->id,
                'type' => $this->discount->type ?? null, // assuming type exists
            ] : null,
        ];
    }
}