<?php

/*
 * Created by Mohamed.
 */


namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;


class DiscountResource extends BaseResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'product_id' => $this->product_id,
            'value' => $this->value,
            'type' => $this->type,
            'usage_limit' => $this->usage_limit,
            'used_count' => $this->used_count,
            'start_date' => $this->start_date,
            'end_date' => $this->end_date,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'product' => new ProductResource($this->whenLoaded('product')),
            'order_items' => OrderItemResource::collection($this->whenLoaded('order_items')),
        ];
    }
}