<?php

/*
    Created by Mohamed.
*/


namespace App\Http\Resources\Dashboard;

use Illuminate\Http\Request;
use App\Http\Resources\GovernorateResource;
use App\Http\Resources\OrderResource;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'full_name' => $this->full_name,
            'email' => $this->email,
            'email_verified_at' => $this->email_verified_at,
            'is_active' => $this->is_active,
            'google_id' => $this->google_id,
            'facebook_id' => $this->facebook_id,
            'second_email' => $this->second_email,
            'zip_code' => $this->zip_code,
            'phone' => $this->phone,
            'status' => $this->status,
            'gender' => $this->gender,
            'orders' => AllOrdersResource::collection($this->orders),
            'governorate' => new GovernorateResource($this->governorate),
            'image' => $this->image ? asset('storage/' . $this->image) : null,
        ];
    }
}
