<?php

namespace App\Http\Resources\Dashboard;

use App\Http\Resources\TagResource;
use App\Http\Resources\ImageResource;
use App\Http\Resources\CategoryResource;
use App\Http\Resources\AdvertisementResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ServiceDetailsResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'category' => new CategoryResource($this->category),
            'advertisements' => AdvertisementResource::collection($this->advertisements),
            'status' => $this->status,
            'discounts' => $this->whenLoaded('discounts'),
            'status_id' => $this->status_id,

            'reviews_rate' => $this->reviews->whereNotNull('rating')->count(),
            'images' => ImageResource::collection($this->images),
            'tags' => TagResource::collection($this->tags),
            'sku' => $this->sku,
            'image' => $this->image ? asset('storage/' . $this->image) : null,


            'name' => [
                'ar' => is_string($this->name) ? (json_decode($this->name, true)['ar'] ?? null) : ($this->name['ar'] ?? null),
                'en' => is_string($this->name) ? (json_decode($this->name, true)['en'] ?? null) : ($this->name['en'] ?? null),
            ],
            'description' => [
                'ar' => is_string($this->description) ? (json_decode($this->description, true)['ar'] ?? null) : ($this->description['ar'] ?? null),
                'en' => is_string($this->description) ? (json_decode($this->description, true)['en'] ?? null) : ($this->description['en'] ?? null),
            ],
            'short_description' => [
                'ar' => is_string($this->short_description) ? (json_decode($this->short_description, true)['ar'] ?? null) : ($this->short_description['ar'] ?? null),
                'en' => is_string($this->short_description) ? (json_decode($this->short_description, true)['en'] ?? null) : ($this->short_description['en'] ?? null),
            ],

            'price' => $this->price,
            'stock' => $this->stock,
            'publish_at' => $this->publish_at,
            'visibility' => $this->visibility,
            'manufacturer_name' => $this->manufacturer_name,
            'manufacturer_brand' => $this->manufacturer_brand,
            'label' => $this->label,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
