<?php

/*
    Created by Mohamed.
*/


namespace App\Http\Resources\Dashboard;

use Illuminate\Http\Request;
use App\Http\Resources\TagResource;
use App\Http\Resources\BaseResource;
use App\Http\Resources\ImageResource;
use App\Http\Resources\ReviewResource;
use App\Http\Resources\StatusResource;
use App\Http\Resources\ServiceResource;
use App\Http\Resources\CartItemResource;
use App\Http\Resources\CategoryResource;
use App\Http\Resources\DiscountResource;
use App\Http\Resources\AdvertisementResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends BaseResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'category_id' => $this->category_id,
            'sku' => $this->sku,
            'status_id' => $this->status_id,
            'name' => $this->translate('name') ?? $this->name,
            'description' => $this->translate('description') ?? $this->description,
            'short_description' => $this->translate('short_description') ?? $this->short_description,
            'image' => $this->image ? asset('storage/' . $this->image) : null,

            'price' => $this->price, // Keep price as a single value
            'stock' => $this->stock,
            'publish_at' => $this->publish_at,
            'visibility' => $this->visibility,
            'manufacturer_name' => $this->manufacturer_name,
            'manufacturer_brand' => $this->manufacturer_brand,
            'label' => $this->label,
            'type' => $this->type,
            'offer' => $this->offer ? [
                'value' => $this->offer->value, // Convert offer value
                // 'type' => $this->offer->type
            ] : null,
            'created_at' => $this->created_at,
            'category' => new CategoryResource($this->category),
            'advertisements' => AdvertisementResource::collection($this->advertisements),
            'status' => new StatusResource($this->whenLoaded('status')),
            'cart_items' => CartItemResource::collection($this->whenLoaded('cart_items')),
            'discounts' => DiscountResource::collection($this->discounts),
            'reviews' => ReviewResource::collection($this->reviews),
            'reviews_rate' => $this->reviews->whereNotNull('rating')->count(),
            'images' => ImageResource::collection($this->images),
            'tags' => TagResource::collection($this->whenLoaded('tags')),
            // New fields for currency context
            // 'currency_code' => $currencyCode,
            // 'currency_symbol' => $currencySymbol,
            // 'currency_name' => $currencyName,
            // 'country' => $country,
            'services' => ServiceResource::collection($this->services),

        ];
    }
}
