<?php

/*
 * Created by Mohamed.
 */


namespace App\Http\Resources\Dashboard;

use Illuminate\Http\Request;

use App\Http\Resources\BaseResource;
use App\Http\Resources\SubCategoryResource;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends BaseResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->translate('name'),
            'image' => $this->image ? asset($this->image) : null,
            'description' => $this->translate('description'),
            'sub-categories' => SubCategoryResource::collection($this->categories),
        ];
    }
}
