<?php

/*
 * Created by Mohamed.
 */

namespace App\Http\Resources\Dashboard;

use Illuminate\Http\Request;
use App\Http\Resources\SubCategoryResource;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryDetailsResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'parent_id' => $this->parent_id,

            // name in both languages
            'name' => [
                'ar' => is_string($this->name)
                    ? (json_decode($this->name, true)['ar'] ?? null)
                    : ($this->name['ar'] ?? null),

                'en' => is_string($this->name)
                    ? (json_decode($this->name, true)['en'] ?? null)
                    : ($this->name['en'] ?? null),
            ],

            // description in both languages
            'description' => [
                'ar' => is_string($this->description)
                    ? (json_decode($this->description, true)['ar'] ?? null)
                    : ($this->description['ar'] ?? null),

                'en' => is_string($this->description)
                    ? (json_decode($this->description, true)['en'] ?? null)
                    : ($this->description['en'] ?? null),
            ],

            // image
            'image' => $this->image ? asset($this->image) : null,

            // sub categories
            'sub-categories' => SubCategoryResource::collection($this->categories),
        ];
    }
}
