<?php

/*
    * Created by Mohamed.
*/

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CartResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'          => $this->id,
            'user_id'     => $this->user_id,
            // 'phone'       => $this->phone_number,
            'coupon_code' => $this->coupon_code,
            'total_price' => $this->total_price,
            'created_at'  => $this->created_at?->toDateTimeString(),
            'items'       => CartItemResource::collection($this->whenLoaded('cart_items')),
        ];
    }
}
