<?php

/*
    Created by Mohamed.
*/


namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BaseResource extends JsonResource
{
    protected function getLanguage()
    {
        return strtolower(request()->header('Accept-Language', 'ar'));
    }

    protected function translate($field)
    {
        $value = $this->$field;
        $language = $this->getLanguage();
        $fallbackLanguage = 'en';

        if (is_array($value)) {
            return $value[$language] ?? $value[$fallbackLanguage] ?? '';
        }

        if (is_string($value)) {
            $decoded = json_decode($value, true);
            return $decoded[$language] ?? $decoded[$fallbackLanguage] ?? '';
        }

        return '';
    }
}
