<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;

class AdvertisementResource extends BaseResource
{
    public function toArray($request)
    {
        return [
            'id'             => $this->id,

            // title & description multi-lang
            'title'          => $this->translate('title'),
            'description'    => $this->translate('description'),

            'image'          => $this->image ? asset('storage/' . $this->image) : null,
            'default_image'  => $this->default_image ? asset('storage/' . $this->default_image) : null,
            'link'           => $this->link,
            'status'         => $this->status,
            'order'          => $this->order,
            'key'            => $this->key,
            'location_type'  => $this->location_type,
            'locatable_id'   => $this->locatable_id,
            'locatable_type' => $this->locatable_type,

            // product relation
            'product_id'     => $this->product_id,
            'product'        => $this->product ? [
                'id'          => $this->product->id,
                'name'        => $this->product->translate('name'),
                'price'       => $this->product->price,
                'discount'    => $this->product->discount,
                'final_price' => $this->product->final_price ?? ($this->product->price - ($this->product->discount ?? 0)),
                'image'       => $this->product->image ? asset('storage/' . $this->product->image) : null,
            ] : null,

            // new fields
            'color'                => $this->color,
            'price'                => $this->price,
            'discount'             => $this->discount,
            'btn_bg_color'         => $this->btn_bg_color,
            'border_btn_color'     => $this->border_btn_color,
            'text_btn'             => $this->text_btn,
            'bg_ads_color_default' => $this->bg_ads_color_default,

            'created_at'     => $this->created_at ? $this->created_at->format('Y-m-d H:i:s') : null,
            'updated_at'     => $this->updated_at ? $this->updated_at->format('Y-m-d H:i:s') : null,
        ];
    }
}
