<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AdminResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'phone_number' => $this->phone_number,
            'email' => $this->email,
            'image' => $this->image ? url('storage/' . $this->image) : null,
            'gender' => $this->gender,
            'admin_id' => $this->admin_id,
            'email_verified_at' => $this->email_verified_at,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'roles' => RoleResource::collection($this->roles),
            'country' => new CountryResource($this->country),

            'city' => $this->city,
            'street' => $this->street,
            'addres_line' => $this->addres_line,
            'qualification' => $this->qualification,
            'current_adjective' => $this->current_adjective,

            'start_date' => $this->start_date,
            'end_date' => $this->end_date,
            'total_working_hours' => $this->total_working_hours,
            'performance' => $this->performance,
            'level' => $this->level,
            'commitment' => $this->commitment,
            'behavior' => $this->behavior,
            'rating' => $this->rating,
            'projects' => $this->projects,
            'development' => $this->development,
            'promotion' => $this->promotion,
            'work_hours' => $this->work_hours,
            'extra_time' => $this->extra_time,
            'absence' => $this->absence,
            'delay' => $this->delay,
            'permission' => $this->permission,
            'deduct' => $this->deduct,
        ];
    }
}