<?php

/*
    Created by Mohamed.
*/


namespace App\Http\Controllers\API;

use App\Models\Subscription;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;

class SubscriptionController extends Controller
{
    public function store(Request $request)
    {
        // التحقق من البيانات المدخلة
        $validator = Validator::make($request->all(), [
            'email' => 'required|email|unique:subscriptions,email|max:255',
            'ip_address' => 'nullable|ip', // تحقق من إن IP صالح لو موجود
        ], [
            'email.required' => 'البريد الإلكتروني مطلوب.',
            'email.email' => 'البريد الإلكتروني غير صالح.',
            'email.unique' => 'البريد الإلكتروني مسجل مسبقًا.',
            'email.max' => 'البريد الإلكتروني يجب ألا يتجاوز 255 حرفًا.',
            'ip_address.ip' => 'عنوان IP غير صالح.',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'message' => 'فشل التحقق من البيانات',
                'errors' => $validator->errors(),
            ], 422);
        }

        // جلب عنوان IP
        $ipAddress = $request->ip();

        try {
            // محاولة جلب بيانات الموقع من IP-API
            $response = Http::timeout(5)->get('http://ip-api.com/json/' . $ipAddress);

            if ($response->failed() || $response->json()['status'] === 'fail') {
                throw new \Exception('فشل جلب بيانات الموقع من IP-API');
            }

            $locationData = $response->json();

            // إنشاء الاشتراك مع بيانات الموقع
            $subscription = Subscription::create([
                'email' => $request->email,
                'ip_address' => $ipAddress,
                'country' => $locationData['country'] ?? null,
                'city' => $locationData['city'] ?? null,
            ]);

            return response()->json([
                'message' => 'تم إنشاء الاشتراك بنجاح',
                'subscription' => [
                    'id' => $subscription->id,
                    'email' => $subscription->email,
                    'ip_address' => $subscription->ip_address,
                    'country' => $subscription->country,
                    'city' => $subscription->city,
                    'created_at' => $subscription->created_at,
                ],
            ], 201);
        } catch (\Exception $e) {
            // تسجيل الخطأ في الـ logs
            Log::error('فشل جلب بيانات الموقع للاشتراك: ' . $e->getMessage(), [
                'email' => $request->email,
                'ip_address' => $ipAddress,
            ]);

            // إنشاء الاشتراك بدون بيانات الموقع
            $subscription = Subscription::create([
                'email' => $request->email,
                'ip_address' => $ipAddress,
                'country' => null,
                'city' => null,
            ]);

            return response()->json([
                'message' => 'تم إنشاء الاشتراك بنجاح، لكن فشل جلب بيانات الموقع',
                'subscription' => [
                    'id' => $subscription->id,
                    'email' => $subscription->email,
                    'ip_address' => $subscription->ip_address,
                    'country' => $subscription->country,
                    'city' => $subscription->city,
                    'created_at' => $subscription->created_at,
                ],
            ], 201);
        }
    }
}
