<?php

/*
    Created by Mohamed.
*/


namespace App\Http\Controllers\API;

use App\Models\Favourite;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\FavouriteResource;

class FavouriteController extends Controller
{
    // إضافة منتج إلى المفضلة
    public function addFavourite(Request $request)
    {
        $validated = $request->validate([
            'product_id' => 'required|exists:products,id',
        ]);

        /** @var \App\Models\User|\Laravel\Sanctum\HasApiTokens $user */
        $user = $request->user();

        if (!$user) {
            return response()->json(['message' => 'غير مصرح'], 401);
        }

        // التحقق إذا كان المنتج موجودًا بالفعل في المفضلة
        $existingFavourite = $user->favourites()->where('product_id', $validated['product_id'])->first();
        if ($existingFavourite) {
            return response()->json(['message' => 'المنتج موجود بالفعل في المفضلة'], 400);
        }

        $favourite = $user->favourites()->create([
            'product_id' => $validated['product_id'],
        ]);

        return response()->json([
            'message' => 'تم إضافة المنتج إلى المفضلة بنجاح',
            'favourite' => new FavouriteResource($favourite),
        ], 201);
    }

    // إزالة منتج من المفضلة
    public function removeFavourite(Request $request)
    {
        $validated = $request->validate([
            'product_id' => 'required|exists:products,id',
        ]);

        /** @var \App\Models\User|\Laravel\Sanctum\HasApiTokens $user */
        $user = $request->user();

        if (!$user) {
            return response()->json(['message' => 'غير مصرح'], 401);
        }

        $favourite = $user->favourites()->where('product_id', $validated['product_id'])->first();

        if (!$favourite) {
            return response()->json(['message' => 'المنتج غير موجود في المفضلة'], 404);
        }

        $favourite->delete();

        return response()->json(['message' => 'تم إزالة المنتج من المفضلة بنجاح']);
    }

    // عرض المفضلة
    public function getFavourites(Request $request)
    {
        /** @var \App\Models\User|\Laravel\Sanctum\HasApiTokens $user */
        $user = $request->user();

        if (!$user) {
            return response()->json(['message' => 'غير مصرح'], 401);
        }

        $favourites = $user->favourites()->with('product')->get();

        return response()->json([
            'message' => 'تم جلب المفضلة بنجاح',
            'favourites' => FavouriteResource::collection($favourites),
        ]);
    }
}