<?php

/*
    Created by Mohamed.
*/


namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use App\Models\Advertisement;
use App\Http\Controllers\Controller;
use App\Http\Resources\AdvertisementResource;

class AdvertisementController extends Controller
{
    public function index(Request $request)
    {
        $locationType = $request->query('location_type');
        $locatableId = $request->query('locatable_id');
        $key = $request->query('key');

        $query = Advertisement::query();

        if ($locationType) {
            $query->where('location_type', $locationType);
        }

        if ($locatableId && $locationType === 'product') {
            $query->where('locatable_id', $locatableId)
                ->where('locatable_type', 'App\\Models\\Product');
        }

        if (isset($key)) {
            $query->where('key', $key);
        }

        $advertisements = $query->get();

        return response()->json(['message' => 'retrive data succ', 'data' =>AdvertisementResource::collection($advertisements) ]);
    }
}