<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        $this->generateUsers(25, Carbon::now()->subMonths(3), '3months');
        $this->generateUsers(25, Carbon::now()->subMonth(), '1month');
        $this->generateUsers(25, Carbon::now()->subWeek(), '1week');
        $this->generateUsers(25, Carbon::now()->subDay(), '1day');
    }

    private function generateUsers($count, Carbon $date, $prefix)
    {
        for ($i = 1; $i <= $count; $i++) {
            User::create([
                'full_name' => "User {$prefix}_{$i}",
                'email' => "user_{$prefix}_{$i}@example.com",
                'password' => Hash::make('password'),
                'is_active' => true,
                'created_at' => $date,
                'updated_at' => $date,
            ]);
        }
    }
}