<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Payment;
use Carbon\Carbon;

class PaymentSeeder extends Seeder
{
    public function run()
    {
        $orderIds = range(1, 341); // نطاق order_id من 1 إلى 341
        $userIds = range(1, 50); // نطاق user_id افتراضي من 1 إلى 50
        $clientNames = ['أحمد محمد', 'فاطمة علي', 'خالد حسن', 'سارة محمود', 'يوسف إبراهيم', 'نورا عبدالله'];
        $products = ['وسائل تواصل اجتماعي', 'تصميم موقع', 'إعلانات', 'تسويق الكتروني'];
        $paymentMethods = ['بطاقة ائتمان', 'تحويل بنكي', 'نقدي', 'محفظة إلكترونية'];
        $banks = ['بنك مصر', 'الاهلي', 'قطر الوطني', 'بنك التنمية'];
        $statuses = ['ناجح', 'معلق', 'فاشل'];

        for ($i = 0; $i < 300; $i++) {
            $orderId = $orderIds[array_rand($orderIds)];
            $userId = $userIds[array_rand($userIds)];
            $clientName = $clientNames[array_rand($clientNames)];
            $product = $products[array_rand($products)];
            $amount = rand(100, 1000) + (rand(0, 99) / 100); // مبلغ عشوائي بين 100 و1000 بـ 2 كسر
            $paymentMethod = $paymentMethods[array_rand($paymentMethods)];
            $bank = $banks[array_rand($banks)];
            $accountNo = '****' . rand(1000, 9999); // رقم حساب عشوائي
            $dueDate = Carbon::now()->subDays(rand(0, 30))->toDateString(); // تاريخ استحقاق حتى 30 يوم مضت
            $paymentStatus = $statuses[array_rand($statuses)];
            $orderTime = Carbon::createFromTime(rand(0, 23), rand(0, 59), 0)->toTimeString();
            $createdAt = Carbon::now()->subDays(rand(0, 60))->toDateTimeString(); // تاريخ إنشاء حتى 60 يوم مضت
            $updatedAt = Carbon::parse($createdAt)->addHours(rand(0, 24))->toDateTimeString(); // تحديث لاحق

            Payment::create([
                'user_id' => $userId,
                'order_id' => $orderId,
                'invoice_no' => 'INV-' . str_pad($i + 1, 4, '0', STR_PAD_LEFT),
                'client_name' => $clientName,
                'order_time' => $orderTime,
                'amount' => $amount,
                'status' => 'ناجح', // افتراض حالة ناجحة دائمًا
                'payment_method' => $paymentMethod,
                'bank_name' => $bank,
                'account_no' => $accountNo,
                'due_date' => $dueDate,
                'payment_status' => $paymentStatus,
                'created_at' => $createdAt,
                'updated_at' => $updatedAt,
            ]);
        }
    }
}