<?php



/*
    Created by Mohamed.
*/


namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
class ResetPasswordOtpNotification extends Notification
{
    use Queueable;
    protected $otp;

    public function __construct($otp)
    {
        $this->otp = $otp;
    }

    public function via($notifiable)
    {
        return ['mail'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('رمز إعادة تعيين كلمة المرور')
            ->line('استخدم رمز التحقق التالي لتغيير كلمة المرور:')
            ->line("رمز التحقق: {$this->otp}")
            ->line('الرمز صالح لمدة 10 دقائق.');
    }
}