<?php

/*
    Created by Mohamed.
*/

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Wallet extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'balance',
        'currency',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function histories()
    {
        return $this->hasMany(WalletHistory::class);
    }

    public function credit($amount, $description = null, $transaction_id = null)
    {
        $this->balance += $amount;
        $this->save();

        return $this->histories()->create([
            'type' => 'credit',
            'amount' => $amount,
            'description' => $description,
            'transaction_id' => $transaction_id,
            'status' => 'completed',
        ]);
    }

    public function debit($amount, $description = null, $transaction_id = null)
    {
        if ($this->balance < $amount) {
            throw new \Exception('Insufficient balance');
        }

        $this->balance -= $amount;
        $this->save();

        return $this->histories()->create([
            'type' => 'debit',
            'amount' => $amount,
            'description' => $description,
            'transaction_id' => $transaction_id,
            'status' => 'completed',
        ]);
    }
}