<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StaticPage extends Model
{
	use HasFactory;

	protected $table = 'static_pages';

	protected $fillable = [
		'name',
		'description',
		'image',
		'key',
		'title',
	];

	/**
	 * Get the title based on the current app locale.
	 */
	public function getTitleAttribute()
	{
		return app()->getLocale() === 'ar' ? $this->attributes['title_ar'] : $this->attributes['title_en'];
	}

	/**
	 * Get the content based on the current app locale.
	 */
	public function getContentAttribute()
	{
		return app()->getLocale() === 'ar' ? $this->attributes['content_ar'] : $this->attributes['content_en'];
	}
}