<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
	protected $table = 'products';

	protected $casts = [
		'category_id' => 'int',
		'status_id' => 'int',
		'price' => 'float',
		'stock' => 'int',
		'publish_at' => 'datetime'
	];

	protected $fillable = [
		'category_id',
		'sku',
		'status_id',
		'name',
		'description',
		'short_description',
		'image',
		'price',
		'stock',
		'publish_at',
		'visibility',
		'manufacturer_name',
		'manufacturer_brand',
		'label',
		'type'
	];

	public function category()
	{
		return $this->belongsTo(Category::class);
	}

	public function status()
	{
		return $this->belongsTo(Status::class);
	}

	public function cartItems()
	{
		return $this->hasMany(CartItem::class);
	}

	public function discounts()
	{
		return $this->hasMany(Discount::class);
	}

	public function orderItems()
	{
		return $this->hasMany(OrderItem::class);
	}

	public function reviews()
	{
		return $this->hasMany(Review::class);
	}
	public function images()
	{
		return $this->morphMany(Image::class, 'model');
	}
	public function favourites()
	{
		return $this->hasMany(Favourite::class);
	}

	public function advertisements()
	{
		return $this->morphMany(Advertisement::class, 'locatable');
	}

	public function tags()
	{
		return $this->belongsToMany(Tag::class, 'product_tag');
	}
}