<?php

/*
    Created by Mohamed.
*/

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    protected $table = 'payments';

    protected $primaryKey = 'id';

    public $incrementing = true;

    protected $keyType = 'int';

    public $timestamps = false; // Disable default created_at and updated_at if managed manually

    protected $fillable = [
        'user_id',
        'order_id',
        'invoice_no',
        'client_name',
        'order_time',
        'amount',
        'payment_method',
        'bank_name',
        'account_no',
        'due_date',
        'payment_status',
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'id' => 'integer',
        'due_date' => 'date',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Get the user associated with the payment.
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    /**
     * Get the order associated with the payment.
     */
    public function order()
    {
        return $this->belongsTo(Order::class, 'order_id', 'id');
    }

    /**
     * Get all payments for a specific user (inverse of user relationship).
     */
    public function paymentsByUser()
    {
        return $this->hasMany(Payment::class, 'user_id', 'id');
    }

    /**
     * Get all payments for a specific order (inverse of order relationship).
     */
    public function paymentsByOrder()
    {
        return $this->hasMany(Payment::class, 'order_id', 'id');
    }
}