<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    use HasFactory;

    protected $table = 'pages'; // Specify the correct table name

    protected $fillable = [
        'navigation_bar',
        'page_name',
        'page_category',
        'status',
        'visibility',
        'publish_schedule',
        'description',
    ];

    protected $casts = [
        'page_category' => 'string',
        'status' => 'string',
        'visibility' => 'string',
        'publish_schedule' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Constants for page_category
    const CATEGORY_HOME = 'home';
    const CATEGORY_ABOUT = 'about';
    const CATEGORY_SERVICES = 'services';
    const CATEGORY_CONTACT = 'contact';
    const CATEGORY_BLOG = 'blog';

    // Constants for status
    const STATUS_DRAFT = 'draft';
    const STATUS_PUBLISHED = 'published';
    const STATUS_ARCHIVED = 'archived';

    // Constants for visibility
    const VISIBILITY_PUBLIC = 'public';
    const VISIBILITY_PRIVATE = 'private';
    const VISIBILITY_RESTRICTED = 'restricted';

    /**
     * Get the tags associated with this page.
     */
    public function tags()
    {
        return $this->hasMany(PageTag::class);
    }
}