<?php

/*
    Created by Mohamed.
*/


namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Governorate extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<string>
     */
    protected $fillable = ['name', 'country_id'];



    /**
     * Get the country that this governorate belongs to.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function country(): BelongsTo
    {
        return $this->belongsTo(Country::class);
    }

    /**
     * Get the governorate name in the specified locale.
     *
     * @param string $locale
     * @return string|null
     */
    public function getName(string $locale = 'en'): ?string
    {
        return $this->name[$locale] ?? null;
    }
}