<?php

/*
	Created by Mohamed.
*/

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Discount
 * 
 * @property int $id
 * @property int $product_id
 * @property float $value
 * @property string $type
 * @property int|null $usage_limit
 * @property int|null $used_count
 * @property Carbon|null $start_date
 * @property Carbon|null $end_date
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Product $product
 * @property Collection|OrderItem[] $order_items
 *
 * @package App\Models
 */
class Discount extends Model
{
	protected $table = 'discounts';

	protected $casts = [
		'product_id' => 'int',
		'value' => 'float',
		'usage_limit' => 'int',
		'used_count' => 'int',
		'start_date' => 'datetime',
		'end_date' => 'datetime'
	];

	protected $fillable = [
		'product_id',
		'value',
		'type',
		'place',
		'usage_limit',
		'used_count',
		'start_date',
		'end_date',
	];

	public function product()
	{
		return $this->belongsTo(Product::class);
	}

	public function order_items()
	{
		return $this->hasMany(OrderItem::class);
	}

}