<?php

/*
    Created by Mohamed.
*/


namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class Advertisement extends Model
{
    protected $fillable = [
        'title',
        'description',
        'image',
        'location_type',
        'locatable_id',
        'locatable_type',
        'key',
        'product_id',
        'color'
    ];

    protected $casts = [
        'key' => 'boolean',
    ];

    public function locatable()
    {
        return $this->morphTo();
    }
    public function products()
    {
        return $this->hasMany(Product::class, 'product_id');
    }
}