<?php
namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OtpVerificationMail extends Mailable
{
    use Queueable, SerializesModels;

    public $otp;
    public $locale;

    public function __construct($otp, $locale)
    {
        $this->otp = $otp;
        $this->locale = $locale;
    }

    public function build()
    {
        return $this->subject(trans('messages.email_verification_subject', [], $this->locale))
            ->view('emails.otp_verification')
            ->with([
                'otp' => $this->otp,
                'locale' => $this->locale,
            ]);
    }
}