<?php

/*
 * Created by Mohamed.
 */


namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'full_name' => $this->full_name,
            'email' => $this->email,
            'email_verified_at' => $this->email_verified_at,
            'is_active' => $this->is_active,
            'google_id' => $this->google_id,
            'facebook_id' => $this->facebook_id,
            'second_email' => $this->second_email,
            'zip_code' => $this->zip_code,
            'phone' => $this->phone,
            'status' => $this->status,
            'gender' => $this->gender,
            'notification' => new NotificationResource($this->notifications->first()),
            'unread_count' => (int) $this->unread_count,
            'count_order' => (int) $this->count_order,
            'points_count' => (int) $this->points_count,
            'points_value' => (int) $this->points_value,
            'governorate' => new GovernorateResource($this->governorate),
            'image' => $this->image ? asset('storage/' . $this->image) : null, // Convert to URL
        ];
    }

}