<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends BaseResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'category_id' => $this->category_id,
            'sku' => $this->sku,
            'status_id' => $this->status_id,
            'name' => $this->translate('name') ?? $this->name,
            'description' => $this->translate('description') ?? $this->description,
            'short_description' => $this->translate('short_description') ?? $this->short_description,
            'image' => $this->image,
            'price' => $this->price,
            'stock' => $this->stock,
            'publish_at' => $this->publish_at,
            'visibility' => $this->visibility,
            'manufacturer_name' => $this->manufacturer_name,
            'manufacturer_brand' => $this->manufacturer_brand,
            'label' => $this->label,
            'created_at' => $this->created_at,
            'category' => new CategoryResource($this->whenLoaded('category')),
            'status' => new StatusResource($this->whenLoaded('status')),
            'cart_items' => CartItemResource::collection($this->whenLoaded('cart_items')),
            'discounts' => DiscountResource::collection($this->whenLoaded('discounts')),
            //'order_items' => OrderItemResource::collection($this->order_items),
            'reviews' => ReviewResource::collection($this->whenLoaded('reviews')),
            'images' => ImageResource::collection($this->whenLoaded('images')),
            'tags' => TagResource::collection($this->whenLoaded('tags'))
        ];
    }
}