<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PaymentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'order_id' => $this->order_id,
            'invoice_no' => $this->invoice_no,
            'client_name' => $this->client_name,
            'order_time' => $this->order_time,
            'amount' => $this->amount,
            'payment_method' => $this->payment_method,
            'bank_name' => $this->bank_name,
            'account_no' => $this->account_no,
            'due_date' => $this->due_date,
            'payment_status' => $this->payment_status,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            // 'user' => new UserResource($this->user),
            'order' => new OrderResource($this->order),
            //'is_overdue' => $this->isPaymentOverdue(),
            //   'formatted_created_at' => $this->getFormattedCreatedAt(),
        ];
    }
}