<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'full_name' => $this->full_name,
            'email' => $this->email,
            'phone_number' => $this->phone_number,
            'total_price' => $this->total_price,
            'shipping_address' => $this->shipping_address,
            'payment_method' => $this->payment_method,
            'tracking_number' => $this->tracking_number,
            'status_id' => $this->status_id,
            'status' => $this->status ? $this->status->name : null,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'order_items' => OrderItemResource::collection($this->order_items),
            'user' => new UserResource($this->user),

        ];
    }
}