<?php

/*
    Created by Mohamed.
*/

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class NotificationResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'type' => $this->type,
            'data' => $this->data,
            'read_at' => $this->read_at ? Carbon::parse($this->read_at)->toDateTimeString() : null,
            'is_active' => $this->is_active,
            'status' => $this->status,
            'created_date' => $this->created_at->format('Y-m-d'),
            'created_time' => $this->created_at->format('H:i'),
            // 'user' => new UserResource($this->notifiable),
            'unread_count' => (int) $this->unread_count,
        ];
    }
}