<?php

/*
    Created by Mohamed.
*/


namespace App\Http\Resources\Dashboard;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray($request)
    {
        $language = $request->header('Accept-Language', 'en');

        return [
            'id' => $this->id,
            'total' => number_format($this->total_price ?? 0, 2),
            'status' => [
                'id' => $this->status_id,
                'name' => $this->status && is_string($this->status->name) && json_validate($this->status->name)
                    ? json_decode($this->status->name, true)[$language] ?? 'غير متوفر'
                    : ($this->status ? $this->status->name : 'غير متوفر'),
            ],
            'user' => [
                'id' => $this->user?->id ?? null,
                'name' => $this->user?->name ?? 'غير متوفر',
            ],
            'order_items' => $this->order_items->map(function ($item) use ($language) {
                return [
                    'product_id' => $item->product_id,
                    'product_name' => $item->product && is_string($item->product->name) && json_validate($item->product->name)
                        ? json_decode($item->product->name, true)[$language] ?? 'غير متوفر'
                        : ($item->product ? $item->product->name : 'غير متوفر'),
                    'quantity' => $item->quantity ?? 1,
                    'price' => number_format($item->price ?? 0, 2),
                    'subtotal' => number_format(($item->price ?? 0) * ($item->quantity ?? 1), 2),
                ];
            })->toArray(),
            'created_at' => $this->created_at?->toDateTimeString() ?? null,
        ];
    }
}